VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Color Spy 3.0 by PAT or JK"
   ClientHeight    =   2910
   ClientLeft      =   2115
   ClientTop       =   1695
   ClientWidth     =   2955
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   2910
   ScaleWidth      =   2955
   Begin VB.PictureBox HoldColors 
      AutoRedraw      =   -1  'True
      Height          =   255
      Left            =   180
      ScaleHeight     =   13
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   170
      TabIndex        =   17
      Top             =   2460
      Width           =   2603
   End
   Begin VB.PictureBox RelatedColors 
      AutoRedraw      =   -1  'True
      Height          =   255
      Left            =   180
      ScaleHeight     =   13
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   170
      TabIndex        =   16
      Top             =   2160
      Width           =   2603
   End
   Begin VB.CommandButton Command1 
      Caption         =   "???"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   180
      TabIndex        =   3
      Top             =   960
      Width           =   495
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   240
      Top             =   480
   End
   Begin VB.TextBox Text1 
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   1260
      TabIndex        =   2
      Top             =   360
      Width           =   1515
   End
   Begin VB.Frame Frame1 
      Caption         =   "Color Spy"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2775
      Left            =   60
      TabIndex        =   0
      Top             =   60
      Width           =   2835
      Begin VB.PictureBox PicColorDis 
         Height          =   735
         Left            =   120
         ScaleHeight     =   675
         ScaleWidth      =   435
         TabIndex        =   15
         Top             =   1260
         Width           =   495
      End
      Begin VB.HScrollBar SBlue 
         Height          =   255
         LargeChange     =   10
         Left            =   1200
         Max             =   255
         TabIndex        =   11
         Top             =   1740
         Width           =   1515
      End
      Begin VB.HScrollBar SGreen 
         Height          =   255
         LargeChange     =   10
         Left            =   1200
         Max             =   255
         TabIndex        =   10
         Top             =   1500
         Width           =   1515
      End
      Begin VB.HScrollBar SRed 
         Height          =   255
         LargeChange     =   10
         Left            =   1200
         Max             =   255
         TabIndex        =   9
         Top             =   1260
         Width           =   1515
      End
      Begin VB.TextBox Text3 
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   1200
         TabIndex        =   7
         Top             =   900
         Width           =   1515
      End
      Begin VB.TextBox Text2 
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   1200
         TabIndex        =   6
         Top             =   600
         Width           =   1515
      End
      Begin VB.PictureBox Picture1 
         Height          =   495
         Left            =   120
         ScaleHeight     =   435
         ScaleWidth      =   435
         TabIndex        =   1
         Top             =   300
         Width           =   495
      End
      Begin VB.Label Label6 
         Alignment       =   2  'Center
         Caption         =   "Blue:"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         Left            =   720
         TabIndex        =   14
         Top             =   1740
         Width           =   435
      End
      Begin VB.Label Label5 
         Alignment       =   2  'Center
         Caption         =   "Green:"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         Left            =   660
         TabIndex        =   13
         Top             =   1500
         Width           =   495
      End
      Begin VB.Label Label4 
         Alignment       =   2  'Center
         Caption         =   "Red:"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         Left            =   720
         TabIndex        =   12
         Top             =   1260
         Width           =   435
      End
      Begin VB.Label Label3 
         Alignment       =   2  'Center
         Caption         =   "Long:"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         Left            =   720
         TabIndex        =   8
         Top             =   930
         Width           =   435
      End
      Begin VB.Label Label2 
         Caption         =   "HTML:"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         Left            =   720
         TabIndex        =   5
         Top             =   630
         Width           =   435
      End
      Begin VB.Label Label1 
         Alignment       =   2  'Center
         Caption         =   "RGB:"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         Left            =   720
         TabIndex        =   4
         Top             =   330
         Width           =   435
      End
   End
   Begin VB.Image picture2 
      Height          =   480
      Left            =   60
      Picture         =   "Form1.frx":08CA
      Top             =   3000
      Width           =   480
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Color Spy Example
' by PAT or JK
' Date 11.15.99 (program made from my color spy example - 9.27.99) (version 3.0 - 8.9.00)
' E-Mail: patorjk@aol.com
' Webpage: www.patorjk.com

' I don't mind if you use this program to help make your own color spy,
' but please, if you use any direct code copying give me a little credit,
' or at least a shout out. I don't mind when people look at one of my
' projects to help with one of their own. I do mind when people just replace
' my name with their name so they can act like they wrote the program though.

Option Explicit

Private Declare Function GetCursorPos Lib "user32" (lpPoint As POINTAPI) As Long
Private Declare Function GetDC Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function GetPixel Lib "gdi32" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long) As Long
Private Declare Function WindowFromPoint Lib "user32" (ByVal xPoint As Long, ByVal yPoint As Long) As Long
Private Declare Function SetWindowPos Lib "user32" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long

Private Const SWP_NOMOVE = 2
Private Const SWP_NOSIZE = 1
Private Const FLAGS = SWP_NOMOVE Or SWP_NOSIZE
Private Const HWND_TOPMOST = -1
Private Const HWND_NOTOPMOST = -2

Private Type POINTAPI
        x As Long
        y As Long
End Type

Dim Last10Colors(9) As Long ' Holds the last 10 colors
Dim CanChangeFadeBar As Boolean ' Lets us know if we should update the faded bar

Private Sub Command1_Click()
    ' Program Info
    Dim Msg(1 To 5) As String, TheString As String, i As Integer
    Msg(1) = "Program:" & Chr(9) & "Color Spy 3.0"
    Msg(2) = "Author:" & Chr(9) & "PAT or JK"
    Msg(3) = "My site:" & Chr(9) & "http://www.patorjk.com/"
    Msg(4) = "About:" & Chr(9) & "This program allows you to find different color values that you may want to use. It also allows you to get the color value of any pixel on the screen. This can be useful when you see a color you would like to use but don't know its value."
    Msg(5) = "Other:" & Chr(9) & "To get the color value drag and drop the arrow onto the color on the screen."
    For i = 1 To UBound(Msg, 1)
        TheString = TheString & Msg(i) & Chr(13)
    Next
    MsgBox TheString, 32, "PAT or JK"
End Sub

Private Sub Form_Load()
    ' set this window on top
    Call SetWindowPos(Me.hwnd, HWND_TOPMOST, 0, 0, 0, 0, FLAGS)
    ' set the pictures, picture2 is really an image, but that's another story
    Picture1.MouseIcon = picture2.Picture
    Picture1.Picture = picture2.Picture
    ' set it so fade bar can change
    CanChangeFadeBar = True
End Sub

Private Sub HoldColors_Click()
    Call GetPixelOverAndSetValue
    Call ReStackColors(PicColorDis.BackColor)
    Call PaintLast10Colors
End Sub

Private Sub Picture1_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    ' Remove pic from picture box
    Picture1.Picture = Me.Picture
    ' Change the cursor to an up arrow
    Picture1.MousePointer = 99
    CanChangeFadeBar = False
    Timer1.Enabled = True
End Sub

Private Sub Picture1_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
    ' When the mouse goes up we want to make sure and set all
    ' the right color info.
    Dim red As String, Green As String, Blue As String
    ' Get the red, green, and blue color amounts
    ' from the picture backcolor.
    red = CStr(PicColorDis.BackColor And 255)
    Green = CStr(PicColorDis.BackColor \ 256 And 255)
    Blue = CStr(PicColorDis.BackColor \ 65536 And 255)
    
    Timer1.Enabled = False
    
    ' Change the cursor back to normal
    Picture1.MousePointer = 0
    Picture1.Picture = picture2.Picture
    ' set the color info in the textbox
    If Text1.Text <> "RGB(" & red & ", " & Green & ", " & Blue & ")" Then
        Text1.Text = "RGB(" & red & ", " & Green & ", " & Blue & ")"
    End If
    If Text2.Text <> "#" & ToHTML(red) & ToHTML(Green) & ToHTML(Blue) Then
        Text2.Text = "#" & ToHTML(red) & ToHTML(Green) & ToHTML(Blue)
    End If
    If Text3.Text <> PicColorDis.BackColor Then
        Text3.Text = PicColorDis.BackColor
    End If
    
    Call ReStackColors(PicColorDis.BackColor)
    Call PaintLast10Colors
    CanChangeFadeBar = True
    Call FadePicBox(PicColorDis.BackColor)
End Sub

Private Sub RelatedColors_Click()
    CanChangeFadeBar = False
    Call GetPixelOverAndSetValue
    Call ReStackColors(PicColorDis.BackColor)
    Call PaintLast10Colors
    CanChangeFadeBar = True
End Sub

Private Sub SBlue_Change()
    ' When the scrollbars change, update the faded bar
    Call ChangeColors
End Sub

Private Sub SBlue_Scroll()
    Call ChangeColors
End Sub

Private Sub SGreen_Change()
    Call ChangeColors
End Sub

Private Sub SGreen_Scroll()
    Call ChangeColors
End Sub

Private Sub SRed_Change()
    Call ChangeColors
End Sub

Private Sub SRed_Scroll()
    Call ChangeColors
End Sub

Private Sub Timer1_Timer()
    Call GetPixelOverAndSetValue
End Sub

Private Function ToHTML(TheColor As String) As String
    ' this sub changes the decimal value into a hex value
    TheColor = Hex(TheColor)
    Do While Len(TheColor) < 2
        TheColor = "0" & TheColor
    Loop
    ToHTML = TheColor
End Function

Private Sub ChangeColors()
    ' This sub is called when the scroll bars are moved. It updates
    ' the textboxes, the color, and fade bar.
    Dim red As String, Green As String, Blue As String
    
    ' Get the red, green, and blue color amounts
    ' from scroll bars
    red = SRed.Value
    Green = SGreen.Value
    Blue = SBlue.Value
    
    ' set the picture's new color
    PicColorDis.BackColor = RGB(red, Green, Blue)
    
    ' set the color info in the textbox
    Text1.Text = "RGB(" & red & ", " & Green & ", " & Blue & ")"
    Text2.Text = "#" & ToHTML(red) & ToHTML(Green) & ToHTML(Blue)
    Text3.Text = PicColorDis.BackColor
    
    If CanChangeFadeBar = True Then
        Call FadePicBox(PicColorDis.BackColor)
    End If
End Sub

Private Sub FadePicBox(TheColor As Long)
    ' This sub creates the list of related colors in the
    ' fade bar.
    Dim x As Single, X2 As Single, y As Long, i As Integer
    Dim red1 As Integer, green1 As Integer, blue1 As Integer
    Dim red2 As Integer, green2 As Integer, blue2 As Integer
    Dim pat1 As Single, pat2 As Single, pat3 As Single
    Dim c1 As Single, c2 As Single, c3 As Single
    Dim NumDown As Integer, NumUp As Integer
    
    Call GetColorRange(TheColor, NumDown, NumUp)
   
    ' find the length of the picturebox and cut it into 100 pieces
    X2 = RelatedColors.ScaleWidth / 100
    y = RelatedColors.ScaleHeight
        
    ' setting how much red, green, and blue goes into each of the two colors
    red1 = (TheColor And 255) - NumDown
    green1 = (TheColor \ 256 And 255) - NumDown
    blue1 = (TheColor \ 65536 And 255) - NumDown
    red2 = (TheColor And 255)
    green2 = (TheColor \ 256 And 255)
    blue2 = (TheColor \ 65536 And 255)
    
    ' set the c variables at the starting colors
    c1 = red1
    c2 = green1
    c3 = blue1
    
    ' draw 100 different lines on the picturebox
    For i = 1 To NumDown / 2
        RelatedColors.Line (x, 0)-(x + X2, y), RGB(MakeOK(c1), MakeOK(c2), MakeOK(c3)), BF
        x = x + X2    ' draw the next line one step up from the old step
        c1 = c1 + 2 ' make the c variable equal 2 it's next step
        c2 = c2 + 2
        c3 = c3 + 2
    Next
    
    ' setting how much red, green, and blue goes into each of the two colors
    red1 = (TheColor And 255)
    green1 = (TheColor \ 256 And 255)
    blue1 = (TheColor \ 65536 And 255)
    red2 = (TheColor And 255) + NumUp
    green2 = (TheColor \ 256 And 255) + NumUp
    blue2 = (TheColor \ 65536 And 255) + NumUp
    
    ' set the c variables at the starting colors
    c1 = red1
    c2 = green1
    c3 = blue1
    
    ' draw 100 different lines on the picturebox
    For i% = NumDown / 2 To (NumDown / 2) + (NumUp / 2)
        RelatedColors.Line (x, 0)-(x + X2, y), RGB(MakeOK(c1), MakeOK(c2), MakeOK(c3)), BF
        x = x + X2 ' draw the next line one step up from the old step
        c1 = c1 + 2 ' make the c variable equal 2 it's next step
        c2 = c2 + 2
        c3 = c3 + 2
    Next
    
    RelatedColors.Refresh
End Sub

Private Function MakeOK(num As Single)
    If num < 0 Then
        MakeOK = 0
    Else
        MakeOK = num
    End If
End Function

Private Sub GetColorRange(TheColor As Long, NumDown As Integer, NumUp As Integer)
    Dim red As Integer, Green As Integer, Blue As Integer
    Dim HighValue As Integer, LowValue As Integer
    red = (TheColor And 255)
    Green = (TheColor \ 256 And 255)
    Blue = (TheColor \ 65536 And 255)
    ' set high value
    HighValue = red
    If HighValue < Green Then
        HighValue = Green
    End If
    If HighValue < Blue Then
        HighValue = Blue
    End If
    ' set low value
    LowValue = red
    If LowValue > Green Then
        LowValue = Green
    End If
    If LowValue > Blue Then
        LowValue = Blue
    End If
    
    ' set NumDown and NumUp
    If (LowValue - 100) >= 0 And (HighValue + 100) <= 255 Then
        NumDown = 100
        NumUp = 100
    ElseIf (LowValue - 100) < 0 Then
        NumDown = LowValue
        NumUp = 100 + (100 - LowValue)
    Else
        NumUp = 255 - HighValue
        NumDown = 100 + ((HighValue + 100) - 255)
    End If
End Sub

Private Sub ReStackColors(NewColor As Long)
    Dim i As Integer
    For i = UBound(Last10Colors, 1) To 1 Step -1
        Last10Colors(i) = Last10Colors(i - 1)
    Next
    Last10Colors(0) = NewColor
End Sub

Private Sub PaintLast10Colors()
    Dim i As Integer, y As Integer, x As Single, X2 As Single
    X2 = RelatedColors.ScaleWidth / 10
    y = RelatedColors.ScaleHeight
    For i = LBound(Last10Colors, 1) To UBound(Last10Colors, 1)
        HoldColors.Line (x, 0)-(x + X2, y), Last10Colors(i), BF
        x = x + X2
    Next
End Sub

Private Sub GetPixelOverAndSetValue()
    Dim ScreenDC As Long, C As POINTAPI, red As String, Green As String
    Dim Blue As String, ThePix As Long, HTMLValue As String
    ' Get the position of the cursor and store
    ' the x and y values in the C variable
    Call GetCursorPos(C)
    ScreenDC = GetDC(0)
    ' get the pixel and set the picture's
    ' backcolor to it.
    ThePix = GetPixel(ScreenDC, C.x, C.y)
    If PicColorDis.BackColor <> ThePix Then
        PicColorDis.BackColor = ThePix
    End If
    DoEvents
    ' Get the red, green, and blue color amounts
    ' from the picture backcolor.
    red = CStr(PicColorDis.BackColor And 255)
    Green = CStr(PicColorDis.BackColor \ 256 And 255)
    Blue = CStr(PicColorDis.BackColor \ 65536 And 255)

    SRed.Value = red
    SGreen.Value = Green
    SBlue.Value = Blue
    
    ' set the color info in the textbox
    If Text1.Text <> "RGB(" & red & ", " & Green & ", " & Blue & ")" Then
        Text1.Text = "RGB(" & red & ", " & Green & ", " & Blue & ")"
    End If
    
    HTMLValue = "#" & ToHTML(red) & ToHTML(Green) & ToHTML(Blue)
    If Text2.Text <> HTMLValue Then
        Text2.Text = HTMLValue
    End If
    
    If Text3.Text <> CStr(PicColorDis.BackColor) Then
        Text3.Text = PicColorDis.BackColor
    End If
End Sub
